/******************************************************************************
 CUnits.c

				CUnits ArrayPane Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 9:07 PM Tue, Sep 28, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the document class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CUnits.h"
#include <string.h>

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICUnits

	Initialize the object

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void	CUnits::ICUnits(
	CView			*anEnclosure,
	CBureaucrat		*aSupervisor,
	short			aWidth,
	short			aHeight,
	short			aHEncl,
	short			aVEncl,
	SizingOption	aHSizing,
	SizingOption	aVSizing)
{
	x_CUnits::Ix_CUnits(anEnclosure, aSupervisor,
					aWidth, aHeight, aHEncl, aVEncl, aHSizing, aVSizing);

		// Initialize your own data members below
	units = NULL;
	unit_count = 0;
	haveUnits = false;
}

/******************************************************************************
 SetLibUnits
 ******************************************************************************/

void	CUnits::SetLibUnits(int count, LibUnit *u)
{
	short rowsInTable;

	unit_count = count;
	units = u;
	if (unit_count > 0)
		haveUnits = true;

	Prepare();
	GetFontInfo(&fontInfo);
	defRowHeight = fontInfo.ascent + fontInfo.descent + fontInfo.leading + 3;
	indent.v = defRowHeight - 3;
	ForceNextPrepare();

	rowsInTable = GetRowCount();
	if (unit_count > rowsInTable)
		AddRow(unit_count - rowsInTable, -1);
	else if (unit_count < rowsInTable)
		DeleteRow(rowsInTable - unit_count, 0);

	col[0] = indent.h;
	col[1] = col[0] + fontInfo.widMax * strlen("obsolete");
	col[2] = col[1] + fontInfo.widMax * strlen("(Interface)");
	col[3] = col[2] + fontInfo.widMax * 15;

}


/******************************************************************************
  GetUnit
 ******************************************************************************/

Boolean	CUnits::GetUnit(Cell theCell, UnitKind *ukind,
	MainKind *mkind, StringPtr theUnit)
{

	if ((theCell.v >= 0) && (theCell.v < unit_count)) {

		// Copy text string to theUnit
		char *a = units[theCell.v].uname;
		short len = strlen(a);

		BlockMove(a, &theUnit[1], len);
		theUnit[0] = len;
		*ukind = units[theCell.v].ukind;
		*mkind = units[theCell.v].mkind;

		return true;
	}
	else
		return false;

}

/******************************************************************************
  GetSelectedUnit()
 ******************************************************************************/

Boolean	CUnits::GetSelectedUnit(Cell *theCell, UnitKind *ukind,
	MainKind *mkind, StringPtr theUnit)
{
		
	theCell->h = 0;		// start at beginning
	theCell->v = 0;

	// Get next one that is selected
	if (GetSelect(TRUE, theCell)) {

		// Copy text string to theUnit
		char *a = units[theCell->v].uname;
		short len = strlen(a);

		BlockMove(a, &theUnit[1], len);
		theUnit[0] = len;
		*ukind = units[theCell->v].ukind;
		*mkind = units[theCell->v].mkind;

		return true;
	}
	else
		return false;
}

/******************************************************************************
 DrawCell
 
 	Draw a single cell. The default is text call GetCellText and then
 	draw that text. If your table is textual you could just override
 	GetCellText. If the cells don't have text, or have text plus other
 	graphics, then override DrawCell.
 	cellRect is already translated from long to QD coordinates.
******************************************************************************/

void CUnits::DrawCell( Cell theCell, Rect *cellRect)
{
	
	if (!haveUnits || (theCell.v > unit_count))
		inherited::DrawCell(theCell, cellRect);

	else {
		register char *a;
		char str[200];
		
		MoveTo( cellRect->left + col[0], cellRect->top + indent.v);
		switch (units[theCell.v].cstatus) {
			case kActive:
				a = "active";
				break;
			default:
				a = "obsolete";
				break;
		}
		DrawText(a, 0, strlen(a));
		
		MoveTo( cellRect->left + col[1], cellRect->top + indent.v);
		a = "-";
		switch (units[theCell.v].mkind) {
			case kMainInterface:
				a = "(Interface)";
				break;
			case kMain:
				a = "(Main)";
				break;
		}
		DrawText(a, 0, strlen(a));
		
		MoveTo( cellRect->left + col[2], cellRect->top + indent.v);
		a = units[theCell.v].comp_date;
		DrawText(a, 0, strlen(a));
		
		MoveTo( cellRect->left + col[3], cellRect->top + indent.v);
		formatted_name(&units[theCell.v], str);
		DrawText(str, 0, strlen(str));

	}

}	/* CUnits::DrawCell */


